/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IDimension;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IScoreboard;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.entity.data.IData;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.DimensionWrapper;
import noppes.npcs.api.wrapper.ScoreboardWrapper;
import noppes.npcs.api.wrapper.data.Data;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.reflection.world.WorldReflection;
import noppes.npcs.reflection.world.biome.BiomeReflection;
import noppes.npcs.util.Util;

public class WorldWrapper
implements IWorld {
    private static final Data tempdata = new Data();
    private static final Data storeddata = new Data();
    public IDimension dimension;
    public World world;

    @Deprecated
    public static WorldWrapper createNew(World world) {
        return new WorldWrapper(world);
    }

    private WorldWrapper(World world) {
        this.world = world;
        this.dimension = new DimensionWrapper(world.field_73011_w.getDimension(), world.field_73011_w.func_186058_p());
    }

    public static void clearTempdata() {
        tempdata.clear();
    }

    @Override
    public void broadcast(String message) {
        if (this.world.func_73046_m() != null) {
            this.world.func_73046_m().func_184103_al().func_148539_a((ITextComponent)new TextComponentString(message));
        } else if (CustomNpcs.Server != null) {
            CustomNpcs.Server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(message));
        } else {
            EntityPlayer player = CustomNpcs.proxy.getPlayer();
            if (player != null) {
                player.func_145747_a((ITextComponent)new TextComponentString(message));
            }
        }
    }

    @Override
    public IEntity<?> createEntity(String id) {
        ResourceLocation resource = new ResourceLocation(id);
        Entity entity = EntityList.func_188429_b((ResourceLocation)resource, (World)this.world);
        if (entity == null) {
            throw new CustomNPCsException("Failed to create an entity from given id: " + id, new Object[0]);
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIEntity(entity);
    }

    @Override
    public IEntity<?> createEntityFromNBT(INbt nbt) {
        Entity entity = EntityList.func_75615_a((NBTTagCompound)nbt.getMCNBT(), (World)this.world);
        if (entity == null) {
            throw new CustomNPCsException("Failed to create an entity from given NBT", new Object[0]);
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIEntity(entity);
    }

    @Override
    public IItemStack createItem(String name, int damage, int size) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(name));
        if (item == null) {
            throw new CustomNPCsException("Unknown item id: " + name, new Object[0]);
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(new ItemStack(item, size, damage));
    }

    @Override
    public IItemStack createItemFromNbt(INbt nbt) {
        ItemStack item = new ItemStack(nbt.getMCNBT());
        if (item.func_190926_b()) {
            throw new CustomNPCsException("Failed to create an item from given NBT", new Object[0]);
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(item);
    }

    @Override
    public void explode(double x, double y, double z, float range, boolean fire, boolean grief) {
        this.world.func_72885_a(null, x, y, z, range, fire, grief);
    }

    @Override
    public void forcePlaySoundAt(int categoryType, IPos pos, String sound, float volume, float pitch) {
        Server.sendRangedData(this.world, pos.getMCBlockPos(), 16, EnumPacketClient.FORCE_PLAY_SOUND, categoryType, sound, Float.valueOf((float)pos.getX()), Float.valueOf((float)pos.getY()), Float.valueOf((float)pos.getZ()), Float.valueOf(volume), Float.valueOf(pitch));
    }

    @Override
    public IEntity<?>[] getAllEntities(int type) {
        List entities = this.world.func_175644_a(this.getClassForType(type), EntitySelectors.field_180132_d);
        ArrayList list = new ArrayList();
        for (Entity living : entities) {
            list.add(Objects.requireNonNull(NpcAPI.Instance()).getIEntity(living));
        }
        return list.toArray(new IEntity[0]);
    }

    @Override
    public IPlayer<?>[] getAllPlayers() {
        List list = Objects.requireNonNull(this.world.func_73046_m()).func_184103_al().func_181057_v();
        IPlayer[] arr = new IPlayer[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            arr[i] = (IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)list.get(i));
        }
        return arr;
    }

    @Override
    public String getBiomeName(int x, int z) {
        return BiomeReflection.getBiomeName(this.world.getBiomeForCoordsBody(new BlockPos(x, 0, z)));
    }

    @Override
    @Deprecated
    public IBlock getBlock(int x, int y, int z) {
        return Objects.requireNonNull(NpcAPI.Instance()).getIBlock(this.world, new BlockPos(x, y, z));
    }

    @Override
    public IBlock getBlock(IPos pos) {
        if (pos == null) {
            return null;
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIBlock(this.world, pos.getMCBlockPos());
    }

    private Class getClassForType(int type) {
        switch (type) {
            case 1: {
                return EntityPlayer.class;
            }
            case 2: {
                return EntityNPCInterface.class;
            }
            case 3: {
                return EntityMob.class;
            }
            case 4: {
                return EntityAnimal.class;
            }
            case 5: {
                return EntityLivingBase.class;
            }
            case 6: {
                return EntityItem.class;
            }
            case 7: {
                return EntityProjectile.class;
            }
            case 8: {
                return PixelmonHelper.getPixelmonClass();
            }
            case 9: {
                return EntityVillager.class;
            }
            case 10: {
                return EntityArrow.class;
            }
            case 11: {
                return EntityThrowable.class;
            }
        }
        return Entity.class;
    }

    @Override
    @Deprecated
    public IEntity<?> getClone(int tab, String name) {
        return Objects.requireNonNull(NpcAPI.Instance()).getClones().get(tab, name, this);
    }

    @Override
    @Deprecated
    public IEntity<?> getClosestEntity(int x, int y, int z, int range, int type) {
        return this.getClosestEntity(new BlockPosWrapper(new BlockPos(x, y, z)), range, type);
    }

    @Override
    public IEntity<?> getClosestEntity(IPos pos, int range, int type) {
        List list = Util.instance.getEntitiesWithinDist(this.getClassForType(type), this.world, pos.getX(), pos.getY(), pos.getZ(), range);
        double distance = 0.0;
        Entity entity = null;
        for (Entity e : list) {
            double r = pos.getMCBlockPos().func_177951_i((Vec3i)e.func_180425_c());
            if (entity != null && r >= distance) continue;
            distance = r;
            entity = e;
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIEntity(entity);
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public IEntity<?> getEntity(String uuid) {
        List<Entity> unloadedEntityList;
        UUID id = null;
        try {
            id = UUID.fromString(uuid);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        if (id == null) {
            throw new CustomNPCsException("Given uuid was invalid " + uuid, new Object[0]);
        }
        EntityPlayer e = null;
        for (Entity entity : this.world.field_72996_f) {
            if (!entity.func_110124_au().equals(id)) continue;
            e = entity;
            break;
        }
        if (e == null && (unloadedEntityList = WorldReflection.getUnloadedEntityList(this.world)) != null) {
            for (Entity entity : unloadedEntityList) {
                if (!entity.func_110124_au().equals(id)) continue;
                e = entity;
                break;
            }
        }
        if (e == null) {
            e = this.world.func_152378_a(id);
        }
        if (e == null) {
            return null;
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)e);
    }

    @Override
    public IEntity<?>[] getEntitys(int type) {
        ArrayList list = new ArrayList();
        for (Entity living : this.world.field_72996_f) {
            IEntity<?> ie = Objects.requireNonNull(NpcAPI.Instance()).getIEntity(living);
            if (ie.getType() != type) continue;
            list.add(Objects.requireNonNull(NpcAPI.Instance()).getIEntity(living));
        }
        return list.toArray(new IEntity[0]);
    }

    @Override
    public float getLightValue(int x, int y, int z) {
        return (float)this.world.func_175699_k(new BlockPos(x, y, z)) / 16.0f;
    }

    @Override
    public BlockPos getMCBlockPos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    @Override
    public World getMCWorld() {
        return this.world;
    }

    @Override
    public String getName() {
        return this.world.func_72912_H().func_76065_j();
    }

    @Override
    @Deprecated
    public IEntity<?>[] getNearbyEntities(int x, int y, int z, int range, int type) {
        return this.getNearbyEntities(new BlockPosWrapper(new BlockPos(x, y, z)), range, type);
    }

    @Override
    public IEntity<?>[] getNearbyEntities(IPos pos, int range, int type) {
        List entities = Util.instance.getEntitiesWithinDist(this.getClassForType(type), this.world, pos.getX(), pos.getY(), pos.getZ(), range);
        ArrayList list = new ArrayList();
        for (Entity e : entities) {
            list.add(Objects.requireNonNull(NpcAPI.Instance()).getIEntity(e));
        }
        return list.toArray(new IEntity[0]);
    }

    @Override
    public IPlayer<?> getPlayer(String name) {
        EntityPlayer player = this.world.func_72924_a(name);
        if (player == null) {
            return null;
        }
        return (IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player);
    }

    @Override
    public int getRedstonePower(int x, int y, int z) {
        return this.world.func_175676_y(new BlockPos(x, y, z));
    }

    @Override
    public IScoreboard getScoreboard() {
        return this.world.func_73046_m() == null ? null : new ScoreboardWrapper(this.world.func_73046_m());
    }

    @Override
    public IBlock getSpawnPoint() {
        BlockPos pos = null;
        if (this.world instanceof WorldServer) {
            pos = ((WorldServer)this.world).func_180504_m();
        }
        if (pos == null) {
            pos = this.world.func_175694_M();
        }
        return Objects.requireNonNull(NpcAPI.Instance()).getIBlock(this.world, pos);
    }

    @Override
    public IData getStoreddata() {
        return storeddata;
    }

    @Override
    public IData getTempdata() {
        return tempdata;
    }

    public static IData getTempData() {
        return tempdata;
    }

    public static IData getStoredData() {
        return storeddata;
    }

    @Override
    public long getTime() {
        return this.world.func_72820_D();
    }

    @Override
    public long getTotalTime() {
        return this.world.func_82737_E();
    }

    @Override
    public boolean isDay() {
        return this.world.func_72820_D() % 24000L < 12000L;
    }

    @Override
    public boolean isRaining() {
        return this.world.func_72912_H().func_76059_o();
    }

    @Override
    public void playSoundAt(IPos pos, String sound, float volume, float pitch) {
        Server.sendRangedData(this.world, pos.getMCBlockPos(), 16, EnumPacketClient.PLAY_SOUND, sound, pos.getX(), pos.getY(), pos.getZ(), Float.valueOf(volume), Float.valueOf(pitch));
    }

    @Override
    @Deprecated
    public void removeBlock(int x, int y, int z) {
        this.world.func_175698_g(new BlockPos(x, y, z));
    }

    @Override
    public void removeBlock(IPos pos) {
        this.world.func_175698_g(new BlockPos(pos.getX(), pos.getY(), pos.getZ()));
    }

    @Override
    @Deprecated
    public void setBlock(int x, int y, int z, String name, int meta) {
        Block block = Block.func_149684_b((String)name);
        if (block == null) {
            throw new CustomNPCsException("There is no such block: %s", new Object[0]);
        }
        this.world.func_175656_a(new BlockPos(x, y, z), block.func_176203_a(meta));
    }

    @Override
    public void setBlock(IPos pos, String name, int meta) {
        Block block = Block.func_149684_b((String)name);
        if (block == null) {
            throw new CustomNPCsException("There is no such block: %s", new Object[0]);
        }
        this.world.func_175656_a(new BlockPos(pos.getX(), pos.getY(), pos.getZ()), block.func_176203_a(meta));
    }

    @Override
    public void setRaining(boolean bo) {
        this.world.func_72912_H().func_76084_b(bo);
    }

    @Override
    public void setSpawnPoint(IBlock block) {
        this.world.func_175652_B(new BlockPos(block.getX(), block.getY(), block.getZ()));
    }

    @Override
    public void setTime(long time) {
        this.world.func_72877_b(time);
    }

    @Override
    @Deprecated
    public IEntity<?> spawnClone(double x, double y, double z, int tab, String name) {
        return Objects.requireNonNull(NpcAPI.Instance()).getClones().spawn(x, y, z, tab, name, this);
    }

    @Override
    public void spawnEntity(IEntity<?> entity) {
        Object e = entity.getMCEntity();
        for (Entity el : this.world.field_72996_f) {
            if (!el.func_110124_au().equals(e.func_110124_au())) continue;
            throw new CustomNPCsException("Entity with this UUID already exists", new Object[0]);
        }
        e.func_70107_b(((Entity)e).field_70165_t, ((Entity)e).field_70163_u, ((Entity)e).field_70161_v);
        this.world.func_72838_d(e);
    }

    @Override
    public void spawnParticle(String particle, double x, double y, double z, double dx, double dy, double dz, double speed, int count) {
        EnumParticleTypes particleType = null;
        for (EnumParticleTypes enumParticle : EnumParticleTypes.values()) {
            if (enumParticle.func_179345_d() > 0) {
                if (!particle.startsWith(enumParticle.func_179346_b())) continue;
                particleType = enumParticle;
                break;
            }
            if (!particle.equals(enumParticle.func_179346_b())) continue;
            particleType = enumParticle;
            break;
        }
        if (particleType != null) {
            if (this.world instanceof WorldServer) {
                ((WorldServer)this.world).func_175739_a(particleType, x, y, z, count, dx, dy, dz, speed, new int[0]);
            } else {
                this.world.func_175682_a(particleType, false, x, y, z, dx * speed, dy * speed, dz * speed, new int[]{count});
            }
        }
    }

    @Override
    public void thunderStrike(double x, double y, double z) {
        this.world.func_72942_c((Entity)new EntityLightningBolt(this.world, x, y, z, false));
    }

    @Override
    public void trigger(int id, Object ... arguments) {
        EventHooks.onScriptTriggerEvent(ScriptController.Instance.forgeScripts, id, this, this.getBlock(0, 0, 0).getPos(), null, arguments);
    }

    @Override
    public String getId() {
        if (this.world.field_73011_w != null) {
            return this.world.field_73011_w.func_186058_p().func_186065_b();
        }
        return "nothing";
    }
}

